/*
 * I/O Subsystem definitions
 */

#include <sys/poll.h>

#define FMS_IO_SIZE_INCR 1024
#define FMS_NEW_CONNECT_TIMEOUT 10000	/* allow 10 seconds for first data */

/* Channel event bits */
#define FMS_CH_READ 0x01
#define FMS_CH_WRITE 0x02

/*
 * I/O variables
 */
struct fms_io_vars {

  /* our service connection */
  int service_socket;
  int service_port;

  /* data for maintaining list of file descriptors to poll */
  struct pollfd *poll_array;		/* structs for poll() */
  struct lf_channel **channel_array;	/* links to associated channels */
  uint32_t poll_array_size;		/* number of poll entries alloced */
  uint32_t poll_count;			/* current number of poll items */

};

/*
 * Connection information.  This is the FMS abstraction of a socket.
 */
struct fms_connection {
  struct lf_channel *chp;
  void *addr;
  struct lf_event *timeout_event;

  uint8_t type;		/* connection type */
};

/*
 * prototypes
 */
int init_io_vars(void);
int init_io(void);
void close_io(void);
void close_connection(struct fms_connection *fcp);
